import constants
import random
from bag import *
from mlp import *

train = load('train')
valid = load('valid')
test = load('test')

train_target = load('train_target')
valid_target = load('valid_target')
test_target = load('test_target')

random.seed()

# Standardize the input and output of the training and test method of an algorithm (MLP)
def mytrainmlp(data,target):
  [w,b,v,c,err_train,err_valid,err_class_train,err_class_valid] = train_mlp(data,target,0.01,10,3,None,None,False,False)
  params = [w,b,v,c]
  return params

def mytestmlp(x,params):
  out = mlp(x,params)
  return out


# Train the algorithm with bagging of nboot bootstraps
nboot = 6
boots = [i+1 for i in range(nboot)]
models = bagging(mytrainmlp,train,train_target,nboot)
res = bagging_test(mytestmlp,models,test,test_target,mse_cost)
# Plot the error of the incremental aggregation of models
plot(boots,array(res),label="bagging error")
xlabel('number of bootstraps')
ylabel('error')
grid(True)
title('Bagging Error using MLP')
savefig("out_bag_mlp.eps")
show()

